/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.event;

import com.github.jarva.arsadditions.server.storage.ChunkLoadingData;
import com.github.jarva.arsadditions.setup.config.ServerConfig;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="ars_additions")
public class ChunkLoadingEvents {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        UUID uuid = player.getUUID();
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        MinecraftServer server = serverLevel.getServer();
        ChunkLoadingData.loadChunks(server, uuid, true);
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        UUID uuid = player.getUUID();
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!((Boolean)ServerConfig.SERVER.chunkloading_require_online.get()).booleanValue()) {
            return;
        }
        MinecraftServer server = serverLevel.getServer();
        ChunkLoadingData.loadChunks(server, uuid, false);
    }
}

